import { useState, useEffect } from 'react';
import { Menu, X, Sun } from 'lucide-react';

const Header = () => {
  const [isScrolled, setIsScrolled] = useState(false);
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 50);
    };

    window.addEventListener('scroll', handleScroll, { passive: true });
    return () => window.removeEventListener('scroll', handleScroll);
  }, []);

  const navLinks = [
    { label: 'Sunrises', href: '#sunrises' },
    { label: 'Travel', href: '#travel' },
    { label: 'Stories', href: '#stories' },
    { label: 'Map', href: '#map' },
    { label: 'Submit', href: '#submit' },
  ];

  return (
    <header
      className={`fixed top-0 left-0 right-0 z-50 transition-all duration-500 ${
        isScrolled
          ? 'glass-header border-b border-[#1A1D23]/5'
          : 'bg-transparent'
      }`}
    >
      <div className="w-full px-6 lg:px-12">
        <div className="flex items-center justify-between h-16 lg:h-20">
          {/* Logo */}
          <a href="#" className="flex items-center gap-2 group">
            <Sun className={`w-5 h-5 transition-colors duration-300 ${
              isScrolled ? 'text-[#D4A27F]' : 'text-[#D4A27F]'
            }`} />
            <div className="flex flex-col">
              <span className={`font-bold text-sm tracking-tight transition-colors duration-300 ${
                isScrolled ? 'text-[#1A1D23]' : 'text-white'
              }`}>
                5AM
              </span>
              <span className={`text-[10px] leading-none transition-colors duration-300 ${
                isScrolled ? 'text-[#6E727A]' : 'text-white/70'
              }`}>
                Why am I awake?
              </span>
            </div>
          </a>

          {/* Desktop Navigation */}
          <nav className="hidden lg:flex items-center gap-8">
            {navLinks.map((link) => (
              <a
                key={link.label}
                href={link.href}
                className={`text-sm font-medium transition-all duration-300 hover:opacity-100 ${
                  isScrolled
                    ? 'text-[#6E727A] hover:text-[#1A1D23]'
                    : 'text-white/80 hover:text-white'
                }`}
              >
                {link.label}
              </a>
            ))}
          </nav>

          {/* Right Side Actions */}
          <div className="hidden lg:flex items-center gap-4">
            <a
              href="#"
              className={`text-sm font-medium transition-colors duration-300 ${
                isScrolled
                  ? 'text-[#6E727A] hover:text-[#1A1D23]'
                  : 'text-white/80 hover:text-white'
              }`}
            >
              Sign In
            </a>
            <a
              href="#submit"
              className="btn-primary text-sm py-2.5 px-5"
            >
              Post Your 5AM Moment
            </a>
          </div>

          {/* Mobile Menu Button */}
          <button
            onClick={() => setIsMobileMenuOpen(!isMobileMenuOpen)}
            className={`lg:hidden p-2 transition-colors duration-300 ${
              isScrolled ? 'text-[#1A1D23]' : 'text-white'
            }`}
          >
            {isMobileMenuOpen ? <X className="w-6 h-6" /> : <Menu className="w-6 h-6" />}
          </button>
        </div>
      </div>

      {/* Mobile Menu */}
      <div
        className={`lg:hidden absolute top-full left-0 right-0 glass-header border-b border-[#1A1D23]/5 transition-all duration-300 ${
          isMobileMenuOpen
            ? 'opacity-100 translate-y-0'
            : 'opacity-0 -translate-y-4 pointer-events-none'
        }`}
      >
        <nav className="flex flex-col py-4 px-6">
          {navLinks.map((link) => (
            <a
              key={link.label}
              href={link.href}
              onClick={() => setIsMobileMenuOpen(false)}
              className="py-3 text-[#1A1D23] font-medium border-b border-[#1A1D23]/5 last:border-0"
            >
              {link.label}
            </a>
          ))}
          <div className="flex flex-col gap-3 mt-4 pt-4 border-t border-[#1A1D23]/5">
            <a href="#" className="text-[#6E727A] font-medium">
              Sign In
            </a>
            <a href="#submit" className="btn-primary text-center">
              Post Your 5AM Moment
            </a>
          </div>
        </nav>
      </div>
    </header>
  );
};

export default Header;
